<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';
require_once '../includes/functions.php';

// Check if user has permission to manage suppliers
if (!hasPermission('manage_suppliers')) {
    echo json_encode(['success' => false, 'message' => 'Permission denied']);
    exit;
}

header('Content-Type: application/json');

try {
    // Check for pending supplier receipts
    $stmt = $pdo->query("SELECT COUNT(*) FROM supplier_receipts WHERE status = 'pending'");
    $pending_count = $stmt->fetchColumn();

    echo json_encode([
        'success' => true,
        'has_pending' => $pending_count > 0,
        'pending_count' => $pending_count
    ]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} 